<?php
get_header(); ?>

<main id="primary" class="site-main">
    <div class="container">
        <div class="error-404-container">
            
            <!-- 404 Hero Section -->
            <div class="error-404-hero">
                <div class="error-404-image">
                    <div class="error-number">404</div>
                </div>
                
                <header class="page-header">
                    <h1 class="page-title"><?php esc_html_e('Oops! Page Not Found', 'the-biz-launch'); ?></h1>
                    <div class="error-subtitle">
                        <?php esc_html_e('The page you are looking for doesn\'t exist or has been moved.', 'the-biz-launch'); ?>
                    </div>
                </header>
            </div>

            <!-- 404 Content Section -->
            <div class="error-404-content">
                <div class="error-404-search">
                    <h2><?php esc_html_e('Try Searching', 'the-biz-launch'); ?></h2>
                    <p><?php esc_html_e('Maybe you can find what you\'re looking for with a search:', 'the-biz-launch'); ?></p>
                    <?php get_search_form(); ?>
                </div>

                <!-- Helpful Links Cards -->
                <div class="error-404-cards">
                    <div class="error-card">
                        <div class="error-card-icon">🏠</div>
                        <h3><?php esc_html_e('Go Home', 'the-biz-launch'); ?></h3>
                        <p><?php esc_html_e('Start over from our homepage and navigate to what you need.', 'the-biz-launch'); ?></p>
                        <a href="<?php echo esc_url(home_url('/')); ?>" class="error-card-link">
                            <?php esc_html_e('Take Me Home', 'the-biz-launch'); ?>
                        </a>
                    </div>


                    <div class="error-card">
                        <div class="error-card-icon">📞</div>
                        <h3><?php esc_html_e('Contact Us', 'the-biz-launch'); ?></h3>
                        <p><?php esc_html_e('Can\'t find what you need? Get in touch and we\'ll help you out.', 'the-biz-launch'); ?></p>
                        <?php 
                        // Try to find a contact page
                        $contact_page = get_page_by_path('contact');
                        if (!$contact_page) {
                            $contact_page = get_page_by_title('Contact');
                        }
                        if (!$contact_page) {
                            $contact_page = get_page_by_title('Contact Us');
                        }
                        
                        $contact_url = $contact_page ? get_permalink($contact_page->ID) : home_url('/');
                        ?>
                        <a href="<?php echo esc_url($contact_url); ?>" class="error-card-link">
                            <?php esc_html_e('Contact Us', 'Contacts'); ?>
                        </a>
                    </div>
                </div>

                <!-- Popular/Recent Posts Section -->
                <div class="error-404-posts">
                    <h2><?php esc_html_e('Popular Content', 'the-biz-launch'); ?></h2>
                    <div class="error-posts-grid">
                        <?php
                        // Get recent posts
                        $recent_posts = wp_get_recent_posts(array(
                            'numberposts' => 3,
                            'post_status' => 'publish'
                        ));

                        if ($recent_posts) :
                            foreach ($recent_posts as $post) : ?>
                                <article class="error-post-card">
                                    <?php if (has_post_thumbnail($post['ID'])) : ?>
                                        <div class="error-post-thumbnail">
                                            <a href="<?php echo esc_url(get_permalink($post['ID'])); ?>">
                                                <?php echo get_the_post_thumbnail($post['ID'], 'medium'); ?>
                                            </a>
                                        </div>
                                    <?php endif; ?>
                                    
                                    <div class="error-post-content">
                                        <h3 class="error-post-title">
                                            <a href="<?php echo esc_url(get_permalink($post['ID'])); ?>">
                                                <?php echo esc_html($post['post_title']); ?>
                                            </a>
                                        </h3>
                                        <div class="error-post-excerpt">
                                            <?php 
                                            $excerpt = wp_trim_words($post['post_content'], 15, '...');
                                            echo esc_html($excerpt);
                                            ?>
                                        </div>
                                        <a href="<?php echo esc_url(get_permalink($post['ID'])); ?>" class="error-post-link">
                                            <?php esc_html_e('Read More', 'the-biz-launch'); ?>
                                        </a>
                                    </div>
                                </article>
                            <?php endforeach;
                            wp_reset_postdata();
                        else : ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>

<?php
get_footer(); ?>