<?php
get_header(); ?>
<div class="front-page-container">
    <div class="hero-section">
        <h1 class="main-title"><?php bloginfo('name'); ?></h1>
        <h2 class="hero-subtitle">We believe starting your own business shouldn't feel like reading a textbook in a foreign language!</h2>
        
        <div class="hero-image-container">
            <img src="<?php echo get_template_directory_uri(); ?>/images/graduation.png" alt="" class="hero-image">
        </div>
    </div>
    <div class="cards-container">
        <div class="card">
            <div class="card-content">
                <!-- Card image -->
                <div class="card-image-container">
                    <img src="<?php echo get_template_directory_uri(); ?>/images/learn-more-icon.png" alt="Sole Trader" class="card-image">
                </div>
                <h3 class="card-title">What is a soletrader.</h3>
                <p class="card-description">Learn more about what is a soletrader?</p>
                <a href="<?php echo esc_url(get_permalink(get_page_by_path('what-is-a-sole-trader'))); ?>" class="card-link">
                    Learn More
                </a>
            </div>
        </div>
        <div class="card">
            <div class="card-content">
                <!-- Card image -->
                <div class="card-image-container">
                    <img src="<?php echo get_template_directory_uri(); ?>/images/start-icon.png" alt="Start Journey" class="card-image">
                </div>
                <h3 class="card-title">Start your journey</h3>
                <p class="card-description">Start learning about how to start your being a soletrader.</p>
                <a href="<?php echo esc_url(get_permalink(get_page_by_path('planning'))); ?>" class="card-link">
                    Start
                </a>
            </div>
        </div>
    </div>
</div>
<?php get_footer(); ?>