<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @package The_Biz_Launch
 */
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="profile" href="https://gmpg.org/xfn/11">
   
    <?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
<?php wp_body_open(); ?>
<div id="page" class="site">
    <a class="skip-link screen-reader-text" href="#primary"><?php esc_html_e( 'Skip to content', 'The-Biz-Launch' ); ?></a>
    
    <header id="masthead" class="site-header">
        <nav class="navigation" role="navigation" aria-label="<?php esc_attr_e( 'Main Navigation', 'The-Biz-Launch' ); ?>">
            <div class="nav-container">
                <!-- Logo -->
                <a href="<?php echo esc_url( home_url( '/' ) ); ?>" class="logo" rel="home" aria-label="<?php esc_attr_e( 'Go to homepage', 'The-Biz-Launch' ); ?>">
                    <?php
                    $custom_logo_id = get_theme_mod( 'custom_logo' );
                    if ( $custom_logo_id ) {
                        echo wp_get_attachment_image( $custom_logo_id, 'full', false, array(
                            'class' => 'custom-logo',
                            'alt'   => get_bloginfo( 'name' ) . ' - ' . esc_attr__( 'Logo', 'The-Biz-Launch' ),
                        ) );
                    } else {
                        echo '<span class="site-title">' . get_bloginfo( 'name' ) . '</span>';
                        if ( get_bloginfo( 'description', 'display' ) ) {
                            echo '<span class="site-description">' . get_bloginfo( 'description', 'display' ) . '</span>';
                        }
                    }
                    ?>
                </a>
               
                <!-- Desktop Navigation -->
                <?php
                if ( has_nav_menu( 'primary' ) ) {
                    wp_nav_menu(
                        array(
                            'theme_location' => 'primary',
                            'menu_id'        => 'primary-menu',
                            'container'      => false,
                            'menu_class'     => 'nav-menu',
                            'fallback_cb'    => false,
                            'walker'         => new Custom_Walker_Nav_Menu(),
                        )
                    );
                } else {
                    // Fallback menu for when no menu is assigned
                    echo '<ul class="nav-menu fallback-menu">';
                    wp_list_pages( array(
                        'title_li' => '',
                        'depth'    => 1,
                    ) );
                    echo '</ul>';
                }
                ?>
               
                <!-- Dark Mode Toggle (Desktop) -->
                <button 
                    class="dark-mode-toggle" 
                    onclick="toggleDarkMode()" 
                    aria-label="<?php esc_attr_e( 'Toggle dark mode', 'The-Biz-Launch' ); ?>"
                    title="<?php esc_attr_e( 'Switch between light and dark theme', 'The-Biz-Launch' ); ?>"
                >
                    <span class="dark-mode-text"><?php esc_html_e( '🌙 Dark', 'The-Biz-Launch' ); ?></span>
                </button>
               
                <!-- Mobile Menu Toggle -->
                <button 
                    class="mobile-toggle" 
                    onclick="toggleMobileMenu()" 
                    aria-label="<?php esc_attr_e( 'Toggle mobile menu', 'The-Biz-Launch' ); ?>"
                    aria-expanded="false"
                    aria-controls="mobileNav"
                    title="<?php esc_attr_e( 'Open mobile navigation menu', 'The-Biz-Launch' ); ?>"
                >
                    <span class="hamburger-line"></span>
                    <span class="hamburger-line"></span>
                    <span class="hamburger-line"></span>
                    <span class="screen-reader-text"><?php esc_html_e( 'Menu', 'The-Biz-Launch' ); ?></span>
                </button>
            </div>
        </nav>
       
        <!-- Mobile Navigation -->
        <div class="mobile-nav" id="mobileNav" aria-hidden="true">
            <div class="mobile-nav-content">
                <?php
                // Use mobile menu if available, otherwise fall back to primary menu
                $mobile_menu_location = has_nav_menu( 'mobile' ) ? 'mobile' : 'primary';
                
                if ( has_nav_menu( $mobile_menu_location ) ) {
                    wp_nav_menu(
                        array(
                            'theme_location' => $mobile_menu_location,
                            'menu_id'        => 'mobile-menu',
                            'container'      => false,
                            'menu_class'     => 'mobile-menu-list',
                            'fallback_cb'    => false,
                            'walker'         => new Custom_Walker_Nav_Menu(),
                        )
                    );
                } else {
                    // Fallback menu for mobile when no menu is assigned
                    echo '<ul class="mobile-menu-list fallback-menu">';
                    wp_list_pages( array(
                        'title_li' => '',
                        'depth'    => 2,
                    ) );
                    echo '</ul>';
                }
                ?>
                
                <div class="mobile-actions">
                    <button 
                        class="mobile-dark-toggle" 
                        onclick="toggleDarkMode()"
                        aria-label="<?php esc_attr_e( 'Toggle dark mode', 'The-Biz-Launch' ); ?>"
                        title="<?php esc_attr_e( 'Switch between light and dark theme', 'The-Biz-Launch' ); ?>"
                    >
                        <span class="mobile-dark-text"><?php esc_html_e( '🌙 Toggle Dark Mode', 'The-Biz-Launch' ); ?></span>
                    </button>
                </div>
            </div>
        </div>
    </header><!-- #masthead -->
    
    <main id="primary" class="site-main" role="main">

    