<?php
/**
 * The main template file
 *
* This is the most generic template file in a WordPress theme.
 *
 * @package The_Biz_Launch
 */

get_header();
?>

<div id="content" class="site-content">
    <div class="container">
        <div class="content-area">
            
            <?php if ( is_home() && ! is_front_page() ) : ?>
                <header class="page-header">
                    <h1 class="page-title"><?php single_post_title(); ?></h1>
                </header>
            <?php endif; ?>

            <?php if ( have_posts() ) : ?>

                <div class="posts-container">
                    <?php
                    // Start the Loop
                    while ( have_posts() ) :
                        the_post();
                        ?>
                        
                        <article id="post-<?php the_ID(); ?>" <?php post_class( 'post-item' ); ?>>
                            
                            <?php if ( has_post_thumbnail() ) : ?>
                                <div class="post-thumbnail">
                                    <a href="<?php the_permalink(); ?>" aria-hidden="true" tabindex="-1">
                                        <?php
                                        the_post_thumbnail( 'large', array(
                                            'alt' => the_title_attribute( array( 'echo' => false ) ),
                                        ) );
                                        ?>
                                    </a>
                                </div>
                            <?php endif; ?>

                            <div class="post-content">
                                <header class="entry-header">
                                    <?php
                                    if ( is_singular() ) :
                                        the_title( '<h1 class="entry-title">', '</h1>' );
                                    else :
                                        the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
                                    endif;
                                    ?>

                                    <?php if ( 'post' === get_post_type() ) : ?>
                                        <div class="entry-meta">
                                            <span class="posted-on">
                                                <time class="entry-date published" datetime="<?php echo esc_attr( get_the_date( 'c' ) ); ?>">
                                                    <?php echo esc_html( get_the_date() ); ?>
                                                </time>
                                            </span>
                                            
                                            <span class="byline">
                                                <?php esc_html_e( 'by', 'The-Biz-Launch' ); ?> 
                                                <span class="author vcard">
                                                    <a class="url fn n" href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>">
                                                        <?php echo esc_html( get_the_author() ); ?>
                                                    </a>
                                                </span>
                                            </span>

                                            <?php
                                            $categories_list = get_the_category_list( esc_html__( ', ', 'The-Biz-Launch' ) );
                                            if ( $categories_list ) :
                                                ?>
                                                <span class="cat-links">
                                                    <?php esc_html_e( 'in', 'The-Biz-Launch' ); ?> <?php echo $categories_list; ?>
                                                </span>
                                            <?php endif; ?>
                                        </div><!-- .entry-meta -->
                                    <?php endif; ?>
                                </header><!-- .entry-header -->

                                <div class="entry-content">
                                    <?php
                                    if ( is_singular() || is_home() ) :
                                        the_content( sprintf(
                                            wp_kses(
                                                __( 'Continue reading<span class="screen-reader-text"> "%s"</span>', 'The-Biz-Launch' ),
                                                array(
                                                    'span' => array(
                                                        'class' => array(),
                                                    ),
                                                )
                                            ),
                                            wp_kses_post( get_the_title() )
                                        ) );

                                        wp_link_pages( array(
                                            'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'The-Biz-Launch' ),
                                            'after'  => '</div>',
                                        ) );
                                    else :
                                        the_excerpt();
                                        ?>
                                        <div class="read-more-wrapper">
                                            <a href="<?php echo esc_url( get_permalink() ); ?>" class="read-more-link">
                                                <?php esc_html_e( 'Read More', 'The-Biz-Launch' ); ?>
                                                <span class="screen-reader-text"><?php esc_html_e( 'about', 'The-Biz-Launch' ); ?> "<?php the_title(); ?>"</span>
                                            </a>
                                        </div>
                                    <?php endif; ?>
                                </div><!-- .entry-content -->

                                <?php if ( is_singular() ) : ?>
                                    <footer class="entry-footer">
                                        <?php
                                        $tags_list = get_the_tag_list( '', esc_html_x( ', ', 'list item separator', 'The-Biz-Launch' ) );
                                        if ( $tags_list ) :
                                            ?>
                                            <span class="tags-links">
                                                <?php esc_html_e( 'Tagged', 'The-Biz-Launch' ); ?> <?php echo $tags_list; ?>
                                            </span>
                                        <?php endif; ?>

                                        <?php
                                        edit_post_link(
                                            sprintf(
                                                wp_kses(
                                                    __( 'Edit <span class="screen-reader-text">"%s"</span>', 'The-Biz-Launch' ),
                                                    array(
                                                        'span' => array(
                                                            'class' => array(),
                                                        ),
                                                    )
                                                ),
                                                wp_kses_post( get_the_title() )
                                            ),
                                            '<span class="edit-link">',
                                            '</span>'
                                        );
                                        ?>
                                    </footer><!-- .entry-footer -->
                                <?php endif; ?>
                            </div><!-- .post-content -->
                        </article><!-- #post-<?php the_ID(); ?> -->

                        <?php
                        // If comments are open or we have at least one comment, load up the comment template.
                        if ( is_singular() && ( comments_open() || get_comments_number() ) ) :
                            comments_template();
                        endif;

                    endwhile;
                    ?>
                </div><!-- .posts-container -->

                <?php
                // Pagination
                the_posts_navigation( array(
                    'prev_text' => '<span class="nav-subtitle">' . esc_html__( 'Previous:', 'The-Biz-Launch' ) . '</span> <span class="nav-title">%title</span>',
                    'next_text' => '<span class="nav-subtitle">' . esc_html__( 'Next:', 'The-Biz-Launch' ) . '</span> <span class="nav-title">%title</span>',
                ) );

            else :
                ?>
                <section class="no-results not-found">
                    <header class="page-header">
                        <h1 class="page-title"><?php esc_html_e( 'Nothing here', 'The-Biz-Launch' ); ?></h1>
                    </header><!-- .page-header -->

                    <div class="page-content">
                        <?php if ( is_home() && current_user_can( 'publish_posts' ) ) : ?>
                            <p>
                                <?php
                                printf(
                                    wp_kses(
                                        __( 'Ready to publish your first post? <a href="%1$s">Get started here</a>.', 'The-Biz-Launch' ),
                                        array(
                                            'a' => array(
                                                'href' => array(),
                                            ),
                                        )
                                    ),
                                    esc_url( admin_url( 'post-new.php' ) )
                                );
                                ?>
                            </p>
                        <?php elseif ( is_search() ) : ?>
                            <p><?php esc_html_e( 'Sorry, but nothing matched your search terms. Please try again with some different keywords.', 'The-Biz-Launch' ); ?></p>
                            <?php get_search_form(); ?>
                        <?php else : ?>
                            <p><?php esc_html_e( 'It seems we can\'t find what you\'re looking for. Perhaps searching can help.', 'The-Biz-Launch' ); ?></p>
                            <?php get_search_form(); ?>
                        <?php endif; ?>
                    </div><!-- .page-content -->
                </section><!-- .no-results -->
            <?php endif; ?>

        </div><!-- .content-area -->

        <?php get_sidebar(); ?>

    </div><!-- .container -->
</div><!-- #content -->

<?php
get_footer();
?>