<nav class="navigation">
    <div class="nav-container">
        <!-- Logo -->
        <a href="<?php echo esc_url(home_url('/')); ?>" class="logo">
            <?php if (has_custom_logo()) : ?>
                <?php the_custom_logo(); ?>
            <?php else : ?>
                <?php bloginfo('name'); ?>
            <?php endif; ?>
        </a>
        
        <!-- Desktop Navigation -->
        <?php
        wp_nav_menu(array(
            'theme_location' => 'primary',
            'menu_class' => 'nav-menu',
            'container' => false,
            'fallback_cb' => 'wp_page_menu',
            'items_wrap' => '<ul class="%2$s">%3$s</ul>',
        ));
        ?>
        
        <!-- Dark Mode Toggle (Desktop) -->
        <button class="dark-mode-toggle" onclick="toggleDarkMode()">🌙 Dark</button>
        
        <!-- Mobile Menu Toggle -->
        <div class="mobile-toggle" onclick="toggleMobileMenu()">
            <span></span>
            <span></span>
            <span></span>
        </div>
    </div>
</nav>

<!-- Mobile Navigation -->
<div class="mobile-nav" id="mobileNav">
    <?php
    wp_nav_menu(array(
        'theme_location' => 'mobile',
        'menu_class' => '',
        'container' => false,
        'fallback_cb' => 'wp_page_menu',
        'items_wrap' => '<ul>%3$s</ul>',
    ));
    ?>
    <button class="mobile-dark-toggle" onclick="toggleDarkMode()">🌙 Toggle Dark Mode</button>
</div>