<?php get_header(); ?>

<div class="page-header">
    <h1 class="page-title"><?php the_title(); ?></h1>
    <?php if (has_post_thumbnail()): ?>
        <div class="header-image">
            <?php the_post_thumbnail('medium', array('class' => 'featured-image')); ?>
        </div>
    <?php else: ?>
        <img src="<?php echo get_template_directory_uri(); ?>/assets/images/default-header.jpg" alt="" class="featured-image">
    <?php endif; ?>
</div>

<div class="container">
    <div class="content-area">
        <main class="main-content">
            <?php while (have_posts()): the_post(); ?>
                <article id="post-<?php the_ID(); ?>" <?php post_class('post'); ?>>
                    <div class="post-content">
                        <?php
                        the_content();
                        
                        // If content is empty, show default content
                        if (empty(get_the_content())):
                        ?>
                            <div class="default-content">
                                <h2 class="section-heading">Welcome</h2>
                                <p class="content-paragraph">
                                    This is your page content. You can edit this in the WordPress admin panel.
                                </p>
                                
                                <p class="content-paragraph">
                                    Add your own content, images, and customize this page to fit your needs.
                                </p>
                            </div>
                        <?php endif; ?>
                        
                        <?php
                        wp_link_pages(array(
                            'before' => '<div class="page-links">' . esc_html__('Pages:', 'The-Biz-Launch'),
                            'after'  => '</div>',
                        ));
                        ?>
                    </div>
                </article>
                
                <?php
                // If comments are open or we have at least one comment, load up the comment template.
                if (comments_open() || get_comments_number()):
                    comments_template();
                endif;
                ?>
            <?php endwhile; ?>
        </main>
    </div>
</div>

<?php get_footer(); ?>